package pt.caf_pbs.schooldiskapi.model;

import pt.caf_pbs.schooldiskapi.exceptions.InvalidDataException;

import java.io.Serializable;

public class Lecture implements Serializable {
    private Subject subject;

    public Lecture() {
    }

    public Lecture(Subject subject) {
        this.setSubject(subject);
    }


    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        if (subject != null) {
            this.subject = subject;
        } else {
            String msg = "Lecture: subject = NULL";
            throw new InvalidDataException(msg);
        }
    }

    public boolean isEqualTo(Lecture obj) {
        return this.subject.isEqualTo(obj.subject);
    }

    public boolean isEqualTo(Subject obj) {
        return this.subject.isEqualTo(obj);
    }

    public boolean isEqualTo(String initials) {
        return this.subject.isEqualTo(initials);
    }
}
